function eng = scaleEngine(eng, rescaled_eng_power)
%scaleEngine
%   rescaled_eng_power: kW

% Scaling factor
scalingFactor = rescaled_eng_power/eng.ratedPwr;

% main data
eng.displacement = eng.displacement * scalingFactor;
eng.ratedPwr = rescaled_eng_power;
eng.inertia = eng.inertia * scalingFactor;
eng.mass = eng.mass * scalingFactor;

% Torque limit map
eng.maxTrq.Values = eng.maxTrq.Values * scalingFactor;
if isfield(eng, 'motTrq')
    eng.motTrq.Values = eng.motTrq.Values * scalingFactor;
end

% Map data
eng.fuelFlwRate.GridVectors{2} = eng.fuelFlwRate.GridVectors{2} * scalingFactor;
eng.fuelFlwRate.Values = eng.fuelFlwRate.Values * scalingFactor;

eng.bsfc.GridVectors{2} = eng.bsfc.GridVectors{2} * scalingFactor;

if isfield(eng, 'NOx') && ~isempty(eng.NOx)
    eng.NOx.GridVectors{2} = eng.NOx.GridVectors{2} * scalingFactor;
    eng.NOx.Values = eng.NOx.Values * scalingFactor;
    eng.bsNOx.GridVectors{2} = eng.bsNOx.GridVectors{2} * scalingFactor;
end

if isfield(eng, 'exhFlwRate') && ~isempty(eng.exhFlwRate)
    eng.exhFlwRate.GridVectors{2} = eng.exhFlwRate.GridVectors{2} * scalingFactor;
    eng.exhFlwRate.Values = eng.exhFlwRate.Values * scalingFactor;
end

if isfield(eng, 'exhTemp') && ~isempty(eng.exhTemp)
    eng.exhTemp.GridVectors{2} = eng.exhTemp.GridVectors{2} * scalingFactor;
end

if isfield(eng, 'HC') && ~isempty(eng.HC)
    eng.HC.GridVectors{2} = eng.HC.GridVectors{2} * scalingFactor;
    eng.HC.Values = eng.HC.Values * scalingFactor;
    eng.bsHC.GridVectors{2} = eng.bsHC.GridVectors{2} * scalingFactor;
end

if isfield(eng, 'CO') && ~isempty(eng.CO)
    eng.CO.GridVectors{2} = eng.CO.GridVectors{2} * scalingFactor;
    eng.CO.Values = eng.CO.Values * scalingFactor;
    eng.bsCO.GridVectors{2} = eng.bsCO.GridVectors{2} * scalingFactor;
end

if isfield(eng, 'PM') && ~isempty(eng.PM)
    eng.PM.GridVectors{2} = eng.PM.GridVectors{2} * scalingFactor;
    eng.PM.Values = eng.PM.Values * scalingFactor;
    eng.bsPM.GridVectors{2} = eng.bsPM.GridVectors{2} * scalingFactor;
end


end